<?php
include 'db_connect.php'; // <-- ডাটাবেজ কানেকশন ফাইল যুক্ত করা হয়েছে

$center_name = "Raisa Computer Training Center";
$center_address = "City, District, Bangladesh";
$center_phone = "017xxxxxxxx";
$center_email = "info@raisaict.com";
$center_logo = "Raisa-Computer-Training-Center-Facebook-Page-Logo.png";

// Get student info by id
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id <= 0) die("Invalid receipt ID.");

// $mysqli অবশ্যই db_connect.php থেকে আসবে
$stmt = $mysqli->prepare("SELECT * FROM admissions WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
if($row = $res->fetch_assoc()) {
    // ok
} else {
    die("Receipt not found.");
}
$stmt->close();
$mysqli->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Money Receipt | <?php echo $center_name; ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: 'Roboto', sans-serif; background: #f5f6fa; margin:0; padding:0;}
        .receipt-container {
            background: #fff;
            max-width: 450px;
            margin: 30px auto;
            box-shadow: 0 2px 18px rgba(44,62,80,.15);
            border-radius: 14px;
            padding: 26px 16px 20px 16px;
            position: relative;
        }
        .header {
            text-align: center;
            border-bottom:1px solid #eee;
            padding-bottom:14px;
            margin-bottom:18px;
        }
        .header img {
            width: 60px; height:60px; border-radius:50%; margin-bottom: 10px; box-shadow:0 1px 6px #bbc;
        }
        .center-name {
            font-size: 1.25rem;
            font-weight: bold;
            color:#2C3E50;
            margin-bottom: 3px;
        }
        .center-address {font-size:0.96rem; color:#444;}
        .receipt-title {
            font-size:1.34rem;
            font-weight: 700;
            letter-spacing:1.2px;
            margin: 18px 0 8px 0;
            color: #F39C12;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin:16px 0 12px 0;
        }
        .info-table td {
            padding:7px 6px;
            font-size:1.08rem;
            color:#222;
        }
        .profile-photo {
            width: 87px;
            height: 110px;
            object-fit: cover;
            border-radius: 5px;
            border: 1px solid #ccc;
            float:right;
            margin:2px 0 14px 14px;
            background: #f9f9f9;
        }
        .print-btn-wrap {
            text-align:center;
            margin-top:18px;
        }
        .print-btn, .pdf-btn {
            background: #2980B9;
            color: #fff;
            border: none;
            border-radius: 22px;
            padding: 9px 30px;
            margin: 4px 8px;
            font-size: 1.05rem;
            font-weight: 700;
            cursor: pointer;
            box-shadow: 0 3px 10px rgba(0,0,0,0.08);
            transition: background 0.3s;
            text-decoration: none;
            display: inline-block;
        }
        .print-btn:hover, .pdf-btn:hover {
            background: #F39C12;
            color: #fff;
        }
        @media print {
            body { background: #fff;}
            .print-btn-wrap { display:none !important;}
            .receipt-container { box-shadow:none;}
        }
    </style>
</head>
<body>
    <div class="receipt-container" id="receiptArea">
        <div class="header">
            <img src="<?php echo $center_logo; ?>" alt="logo">
            <div class="center-name"><?php echo $center_name; ?></div>
            <div class="center-address"><?php echo $center_address; ?></div>
            <div style="color:#555;font-size:0.98rem;"><?php echo $center_phone; ?> | <?php echo $center_email;?></div>
            <div class="receipt-title">Money Receipt</div>
        </div>
        <img src="<?php echo $row['photo_path']; ?>" class="profile-photo" alt="photo">
        <table class="info-table">
            <tr>
                <td><b>Student Name</b></td>
                <td><?php echo $row['name']; ?></td>
            </tr>
            <tr>
                <td><b>Course Name</b></td>
                <td><?php echo $row['course_name']; ?></td>
            </tr>
            <tr>
                <td><b>Duration</b></td>
                <td><?php echo $row['course_duration']; ?></td>
            </tr>
            <tr>
                <td><b>Class Time</b></td>
                <td><?php echo $row['class_time']; ?></td>
            </tr>
            <tr>
                <td><b>Course Fee</b></td>
                <td><?php echo $row['course_fee']; ?> BDT</td>
            </tr>
            <tr>
                <td><b>Date</b></td>
                <td><?php echo date("d M, Y", strtotime($row['created_at'])); ?></td>
            </tr>
        </table>
        <div class="print-btn-wrap">
            <button class="print-btn" onclick="window.print()">Print</button>
            <button class="pdf-btn" onclick="downloadPDF()">Download PDF</button>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <script>
    function downloadPDF() {
        const element = document.getElementById('receiptArea');
        html2pdf().from(element).set({
            margin: 0.2,
            filename: 'money-receipt-<?php echo $row['id']; ?>.pdf',
            html2canvas: { scale: 2 },
            jsPDF: {orientation: 'portrait', unit: 'in', format: 'a4'}
        }).save();
    }
    </script>
</body>
</html>