<?php
include 'db_connect.php'; // এখানে আপনার ডাটাবেজ কানেকশন (mysqli $mysqli) ধরে নিন

$success = $error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm_password'] ?? '';
    if (!$username || !$password || !$confirm) {
        $error = "All fields are required!";
    } elseif ($password !== $confirm) {
        $error = "Passwords do not match!";
    } elseif (strlen($password) < 4) {
        $error = "Password must be at least 4 characters!";
    } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $mysqli->prepare("INSERT INTO admins (username, password) VALUES (?,?)");
        $stmt->bind_param("ss", $username, $hash);
        if ($stmt->execute()) {
            $success = "Admin registered successfully!";
        } else {
            $error = "Registration failed! Username may already exist.";
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Registration</title>
    <style>
        body {font-family:Arial;background:#f5f6fa;}
        .register-box {background:#fff;max-width:340px;margin:80px auto;padding:40px 28px;border-radius:8px;box-shadow:0 3px 24px rgba(44,62,80,0.09);}
        h2 {text-align:center;color:#2980B9;}
        input {width:100%;padding:9px 10px;margin-bottom:18px;border:1px solid #dbe3ea;border-radius:4px;}
        button {width:100%;background:#2980B9;color:#fff;font-weight:bold;border:none;padding:12px 0;border-radius:4px;cursor:pointer;}
        .success {color:#155724;background:#d4edda;padding:10px 14px;border-radius:5px;margin-bottom:10px;}
        .error {color:#721c24;background:#f8d7da;padding:10px 14px;border-radius:5px;margin-bottom:10px;}
        .back {text-align:center;margin-top:18px;}
        .back a {color:#2980B9;}
    </style>
</head>
<body>
    <div class="register-box">
        <h2>Admin Registration</h2>
        <?php if($success): ?><div class="success"><?= $success ?></div><?php endif; ?>
        <?php if($error): ?><div class="error"><?= $error ?></div><?php endif; ?>
        <form method="post" autocomplete="off">
            <input type="text" name="username" placeholder="Username" required autofocus>
            <input type="password" name="password" placeholder="Password (min 4 chars)" required>
            <input type="password" name="confirm_password" placeholder="Confirm Password" required>
            <button type="submit">Register</button>
        </form>
        <div class="back">
            <a href="login.php">Back to Login</a>
        </div>
    </div>
</body>
</html>