<?php
session_start();
include 'db_connect.php';

$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $stmt = $mysqli->prepare("SELECT id, password FROM admins WHERE username=?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->bind_result($id, $hash);
    if ($stmt->fetch() && password_verify($password, $hash)) {
        $_SESSION['admin_login'] = $username;
        header("Location: admin_dashboard.php");
        exit;
    } else {
        $error = "Invalid username or password!";
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Login</title>
    <style>
        body {font-family:Arial;background:#f5f6fa;}
        .login-box {background:#fff;max-width:340px;margin:80px auto;padding:40px 28px;border-radius:8px;box-shadow:0 3px 24px rgba(44,62,80,0.09);}
        h2 {text-align:center;color:#2980B9;}
        input {width:100%;padding:9px 10px;margin-bottom:18px;border:1px solid #dbe3ea;border-radius:4px;}
        button {width:100%;background:#2980B9;color:#fff;font-weight:bold;border:none;padding:12px 0;border-radius:4px;cursor:pointer;}
        .error {color:#e3342f;margin-bottom:12px;text-align:center;}
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Admin Login</h2>
        <?php if($error): ?><div class="error"><?= $error ?></div><?php endif; ?>
        <form method="post">
            <input type="text" name="username" placeholder="Username" required autofocus>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>