<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'db_connect.php'; // এখানে $mysqli ব্যবহার হবে

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $title = $mysqli->real_escape_string($_POST['title']);
    $content = $mysqli->real_escape_string($_POST['content']);
    $link = $mysqli->real_escape_string($_POST['link']);
    $created_at = date("Y-m-d H:i:s");

    // Handle file upload
    $filePath = "";
    if (isset($_FILES['file']) && $_FILES['file']['name'] != '') {
        $targetDir = "uploads/";
        if(!is_dir($targetDir)) mkdir($targetDir, 0777, true);
        $filePath = $targetDir . basename($_FILES["file"]["name"]);
        move_uploaded_file($_FILES["file"]["tmp_name"], $filePath);
    }

    // SQL Insert Query (id অটো-ইনক্রিমেন্ট)
    $sql = "INSERT INTO notice (title, content, link, file, created_at)
            VALUES ('$title', '$content', '$link', '$filePath', '$created_at')";
    if ($mysqli->query($sql) === TRUE) {
        $message = "Notice added successfully!";
    } else {
        $message = "Error: " . $mysqli->error;
    }
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>নোটিস এ্যাড করুন</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f8f8f8; }
        .container { max-width: 500px; margin: 40px auto; background: #fff; padding: 24px; border-radius: 8px; box-shadow: 0 0 10px #ddd; }
        label { display: block; margin-top: 15px; }
        input[type=text], textarea { width: 100%; padding: 8px; margin-top: 6px; border: 1px solid #ccc; border-radius: 4px; }
        input[type=file] { margin-top: 6px; }
        input[type=submit] { margin-top: 18px; padding: 10px 30px; background: #2d7cff; color: #fff; border: none; border-radius: 4px; cursor: pointer; }
        .msg { margin-top: 16px; color: green; }
        a { color: #2d7cff; text-decoration: none; }
    </style>
</head>
<body>
    <div class="container">
        <h2>নোটিস এ্যাড করুন</h2>
        <?php if(isset($message)) echo "<div class='msg'>$message</div>"; ?>
        <form method="post" enctype="multipart/form-data">
            <label for="title">নোটিস শিরোনাম</label>
            <input type="text" id="title" name="title" required>

            <label for="content">নোটিস কনটেন্ট</label>
            <textarea id="content" name="content" rows="4" required></textarea>

            <label for="link">লিংক (যদি থাকে)</label>
            <input type="text" id="link" name="link" placeholder="যেমন: https://your-link.com">

            <label for="file">ফাইল আপলোড</label>
            <input type="file" id="file" name="file" accept=".pdf,.doc,.docx,.jpg,.png,.jpeg">

            <input type="submit" value="এ্যাড করুন">
        </form>
        <br>
        <a href="notice_list.php">সকল নোটিস দেখুন</a>
    </div>
</body>
</html>