<?php
session_start(); // Start session
require 'fpdf/fpdf.php';
include 'db_connect.php'; // Include database connection file

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Custom function to convert numbers to words
function convertNumberToWords($number)
{
    $hyphen = '-';
    $conjunction = ' and ';
    $separator = ', ';
    $negative = 'negative ';
    $decimal = ' point ';
    $dictionary = array(
        0 => 'zero',
        1 => 'one',
        2 => 'two',
        3 => 'three',
        4 => 'four',
        5 => 'five',
        6 => 'six',
        7 => 'seven',
        8 => 'eight',
        9 => 'nine',
        10 => 'ten',
        11 => 'eleven',
        12 => 'twelve',
        13 => 'thirteen',
        14 => 'fourteen',
        15 => 'fifteen',
        16 => 'sixteen',
        17 => 'seventeen',
        18 => 'eighteen',
        19 => 'nineteen',
        20 => 'twenty',
        30 => 'thirty',
        40 => 'forty',
        50 => 'fifty',
        60 => 'sixty',
        70 => 'seventy',
        80 => 'eighty',
        90 => 'ninety',
        100 => 'hundred',
        1000 => 'thousand',
        1000000 => 'million',
        1000000000 => 'billion'
    );

    if (!is_numeric($number)) {
        return false;
    }

    if ($number < 0) {
        return $negative . convertNumberToWords(abs($number));
    }

    $string = $fraction = null;

    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }

    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens = ((int) ($number / 10)) * 10;
            $units = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convertNumberToWords($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convertNumberToWords($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convertNumberToWords($remainder);
            }
            break;
    }

    if (null !== $fraction && is_numeric($fraction)) {
        $string .= $decimal;
        $words = array();
        foreach (str_split((string) $fraction) as $number) {
            $words[] = $dictionary[$number];
        }
        $string .= implode(' ', $words);
    }

    return ucfirst($string) . " taka only";
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $donor_name = $_POST['donor_name'];
    $purpose = $_POST['purpose'];
    $amount = $_POST['amount'];
    $amount_in_words = convertNumberToWords($amount);
    $date = date('Y-m-d'); // Automatically use the current date

    // Insert into database
    $stmt = $conn->prepare("INSERT INTO income (donor_name, purpose, amount, amount_in_words, date) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("ssdss", $donor_name, $purpose, $amount, $amount_in_words, $date);
    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Data successfully saved!";
    } else {
        $_SESSION['error_message'] = "Error: " . $stmt->error;
    }

    // Generate PDF
    $pdf = new FPDF();
    $pdf->AddPage();

    // Header Image
    $pdf->Image('PAD.jpg', 10, 10, 190); // Replace with your header image
    $pdf->Ln(50); // Space after header image

    // Original Copy
    $pdf->SetFont('Arial', 'B', 16);
    $pdf->Cell(0, 10, 'Income Original Copy', 0, 1, 'C');
    $pdf->SetFont('Arial', '', 12);
    $pdf->Ln(5);
    $pdf->Cell(50, 7, 'ID:', 5, 0);
    $pdf->Cell(25, 7, $stmt->insert_id, 0, 1);
    $pdf->Cell(50, 7, 'Donor Name:', 0, 0);
    $pdf->Cell(25, 7, $donor_name, 0, 1);
    $pdf->Cell(50, 7, 'Purpose:', 0, 0);
    $pdf->Cell(25, 7, $purpose, 0, 1);
    $pdf->Cell(50, 7, 'Amount (BDT):', 0, 0);
    $pdf->Cell(25, 7, $amount, 0, 1);
    $pdf->Cell(50, 7, 'Amount in Words:', 0, 0);
    $pdf->Cell(25, 7, $amount_in_words, 0, 1);
    $pdf->Cell(50, 7, 'Date:', 0, 0);
    $pdf->Cell(25, 7, $date, 0, 1);
    $pdf->Ln(10);

    // Signatures
    $pdf->Cell(60, 15, 'Donor Signature:', 0, 0);
    $pdf->Cell(60, 15, 'Receiver Signature:', 0, 0);
    $pdf->Cell(60, 15, 'Principal Signature:', 0, 1);
    
    // Carbon Copy
       // Header Image
    $pdf->Ln(5); // Space between copies
    $pdf->Image('PAD.jpg', 5, $pdf->GetY(), 190); // Add header image for carbon copy
    $pdf->Ln(50);

    // carbon Copy
    $pdf->SetFont('Arial', 'B', 16);
    $pdf->Cell(0, 10, 'Income Carbon Copy', 0, 1, 'C');
    $pdf->SetFont('Arial', '', 12);
    $pdf->Ln(5);
    $pdf->Cell(50,7, 'ID:', 0, 0);
    $pdf->Cell(25, 7, $stmt->insert_id, 0, 1);
    $pdf->Cell(50, 7, 'Donor Name:', 0, 0);
    $pdf->Cell(25, 7, $donor_name, 0, 1);
    $pdf->Cell(50, 7, 'Purpose:', 0, 0);
    $pdf->Cell(25, 7, $purpose, 0, 1);
    $pdf->Cell(50, 7, 'Amount (BDT):', 0, 0);
    $pdf->Cell(25, 7, $amount, 0, 1);
    $pdf->Cell(50, 7, 'Amount in Words:', 0, 0);
    $pdf->Cell(25, 7, $amount_in_words, 0, 1);
    $pdf->Cell(50, 7, 'Date:', 0, 0);
    $pdf->Cell(25, 7, $date, 0, 1);
    $pdf->Ln(10);

    // Signatures
    $pdf->Cell(60, 10, 'Donor Signature:', 0, 0);
    $pdf->Cell(60, 10, 'Receiver Signature:', 0, 0);
    $pdf->Cell(60, 10, 'Principal Signature:', 0, 1);

    // Save PDF
    $uploads_dir = 'uploads';
    if (!file_exists($uploads_dir)) {
        mkdir($uploads_dir, 0777, true); // Create the directory with proper permissions
    }
    $pdf_output = $uploads_dir . '/expense_entry_' . $stmt->insert_id . '.pdf';
    $pdf->Output('F', $pdf_output);

    // Provide download link
    $_SESSION['pdf_link'] = $pdf_output;

    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Fetch total balance
$result = $conn->query("SELECT SUM(amount) AS total_income FROM income");
$row = $result->fetch_assoc();
$total_income = $row['total_income'] ?? 0;
?>

<!DOCTYPE html>
<html lang="en">
<head>
        <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Expense Entry</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f9;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
        }
        h2 {
            text-align: center;
            color: #333333;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            color: #555555;
        }
        input, textarea {
            width: 100%;
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-sizing: border-box;
        }
        button {
            padding: 10px 20px;
            font-size: 16px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
        }
        button:hover {
            background-color: #218838;
        }
        .balance {
            margin-top: 20px;
            font-size: 18px;
            color: #333333;
            text-align: center;
        }
        .message {
            margin-bottom: 20px;
            text-align: center;
            font-size: 16px;
        }
        .message.success {
            color: green;
        }
        .message.error {
            color: red;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="PAD.jpg" alt="School Header Image">
        <h2>Income Entry Form</h2>
        <?php if (isset($_SESSION['success_message'])): ?>
            <p style="color: green;"><?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?></p>
        <?php endif; ?>
        <?php if (isset($_SESSION['error_message'])): ?>
            <p style="color: red;"><?php echo $_SESSION['error_message']; unset($_SESSION['error_message']); ?></p>
        <?php endif; ?>
        <form method="POST">
            <label for="donor_name">Donor Name:</label>
            <input type="text" id="donor_name" name="donor_name" required><br>

            <label for="purpose">Purpose:</label>
            <input type="text" id="purpose" name="purpose" required><br>

            <label for="amount">Amount (BDT):</label>
            <input type="number" id="amount" name="amount" step="0.01" required><br>

            <button type="submit">Submit</button>
        </form>
        <p><strong>Total Balance:</strong> <?php echo number_format($total_income, 2); ?> BDT</p>
        <?php if (isset($_SESSION['pdf_link'])): ?>
            <a href="<?php echo $_SESSION['pdf_link']; ?>" target="_blank" style="display: block; margin-top: 20px; text-align: center; font-size: 16px; text-decoration: none; color: white; background-color: #007bff; padding: 10px 20px; border-radius: 5px;">Download PDF</a>
            <?php unset($_SESSION['pdf_link']); ?>
        <?php endif; ?>
    </div>
</body>
</html>