<?php
include 'db_connect.php'; // এখানে আপনার ডাটাবেজ কানেকশন (mysqli $mysqli) ধরে নিন

$success = $error = "";

function clean($v) { return htmlspecialchars(trim($v)); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get and validate all fields
    $name          = clean($_POST['name'] ?? '');
    $father        = clean($_POST['father'] ?? '');
    $mother        = clean($_POST['mother'] ?? '');
    $dob           = $_POST['dob'] ?? '';
    $address       = clean($_POST['address'] ?? '');
    $course_name   = $_POST['course_name'] ?? '';
    $course_duration = $_POST['course_duration'] ?? '';
    $class_time    = $_POST['class_time'] ?? '';
    $course_fee    = $_POST['course_fee'] ?? '';
    $email         = clean($_POST['email'] ?? '');
    $mobile        = clean($_POST['mobile'] ?? '');
    $whatsapp      = clean($_POST['whatsapp'] ?? '');
    $photo_path    = "";

    // Photo validation and resizing
    if(!$error && isset($_FILES['photo']) && $_FILES['photo']['error'] === 0) {
        $f = $_FILES['photo'];
        $ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
        $allowed = array('jpg','jpeg','png');
        if(!in_array($ext, $allowed)){
            $error = "Only JPG or PNG photo allowed!";
        } else {
            $imginfo = getimagesize($f['tmp_name']);
            if(!$imginfo) {
                $error = "Invalid image file!";
            } else {
                $srcimg = null;
                if($imginfo['mime'] == 'image/jpeg') $srcimg = imagecreatefromjpeg($f['tmp_name']);
                else if($imginfo['mime'] == 'image/png') $srcimg = imagecreatefrompng($f['tmp_name']);
                if(!$srcimg) {
                    $error = "Failed to process image!";
                } else {
                    $dstw = 114; $dsth = 140;
                    $dstimg = imagecreatetruecolor($dstw, $dsth);
                    $white = imagecolorallocate($dstimg,255,255,255);
                    imagefill($dstimg,0,0,$white);
                    $scale = min($dstw/$imginfo[0], $dsth/$imginfo[1]);
                    $w = $imginfo[0] * $scale; $h = $imginfo[1] * $scale;
                    $x = ($dstw-$w)/2; $y = ($dsth-$h)/2;
                    imagecopyresampled($dstimg, $srcimg, $x, $y, 0, 0, $w, $h, $imginfo[0], $imginfo[1]);
                    $target = "uploads/";
                    if(!is_dir($target)) mkdir($target,0777,true);
                    $photo_name = uniqid("stu_").".".$ext;
                    $photo_path = $target.$photo_name;
                    if($imginfo['mime']=='image/jpeg')
                        imagejpeg($dstimg, $photo_path, 90);
                    else
                        imagepng($dstimg, $photo_path, 8);
                    imagedestroy($srcimg); imagedestroy($dstimg);
                    if(filesize($photo_path) > 102400){
                        unlink($photo_path);
                        $error = "Photo must be under 100KB after resize!";
                    }
                }
            }
        }
    } elseif(!$error) {
        $error = "Photo required!";
    }

    // Insert into db & redirect to receipt
    if (!$error) {
        $stmt = $mysqli->prepare("INSERT INTO admissions (name, father, mother, dob, address, course_name, course_duration, class_time, course_fee, email, mobile, whatsapp, photo_path, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param("ssssssssssssss",
            $name, $father, $mother, $dob, $address,
            $course_name, $course_duration, $class_time, $course_fee,
            $email, $mobile, $whatsapp, $photo_path
        );
        if($stmt->execute()){
            $insert_id = $stmt->insert_id;
            $stmt->close();
            header("Location: print-receipt.php?id=$insert_id");
            exit;
        } else {
            $error = "Failed to submit application!";
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admission | Raisa Computer Training Center</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
    /* -- CSS অপরিবর্তিত রাখুন, যেমন আপনার মূল ফাইলে ছিল -- */
    @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
    :root {
        --primary: #2C3E50;
        --secondary: #2980B9;
        --accent: #F39C12;
        --bg: #F5F6FA;
        --text: #222;
        --footer: #23272b;
    }
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body {
        font-family: 'Roboto', sans-serif;
        background: var(--bg);
        color: var(--text);
        line-height: 1.6;
    }
    header {
        background: var(--primary);
        color: #fff;
        padding: 0.7rem 0;
        position: sticky;
        top: 0;
        z-index: 100;
    }
    .logo {
        font-size: 2.5rem;
        font-weight: bold;
        letter-spacing: 1px;
        text-align: center;
        margin-bottom: 0.5rem;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.7rem;
    }
    .logo-img {
        height: 58px;
        width: 58px;
        border-radius: 50%;
        object-fit: cover;
        background: #fff;
        border: 2px solid var(--secondary);
        box-shadow: 0 1px 6px rgba(44, 62, 80, 0.10);
    }
    nav {
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
    }
    .menu {
        display: flex;
        flex-wrap: wrap;
        list-style: none;
        gap: 0.5rem;
    }
    .menu li { position: relative; }
    .menu a {
        display: block;
        padding: 0.7rem 1.1rem;
        color: #fff;
        text-decoration: none;
        font-weight: 500;
        border-radius: 5px;
        transition: background 0.3s, color 0.3s, transform 0.2s;
        position: relative;
        z-index: 1;
        overflow: hidden;
    }
    .menu a::before {
        content: "";
        position: absolute;
        left: 50%; top: 50%;
        width: 0; height: 0;
        background: linear-gradient(120deg, var(--secondary), var(--accent));
        border-radius: 50%;
        z-index: -1;
        transition: .4s cubic-bezier(.25,.8,.25,1);
        transform: translate(-50%, -50%);
    }
    .menu a:hover, .menu a:focus, .menu a.active {
        color: var(--primary);
        background: #fff;
        transform: translateY(-3px) scale(1.07);
    }
    .menu a:hover::before, .menu a:focus::before {
        width: 200%;
        height: 500%;
        opacity: 0.12;
    }
    .menu-toggle {
        display: none;
        font-size: 2rem;
        color: #fff;
        cursor: pointer;
        margin-left: 1rem;
    }
    .hero {
        background: url('admission-bg.jpg') center center/cover no-repeat;
        color: #fff;
        padding: 80px 20px 60px 20px;
        text-align: center;
        position: relative;
        min-height: 280px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .hero::after {
        content: "";
        position: absolute;
        inset: 0;
        background: linear-gradient(120deg, #2980b9e6 60%, #f39c12b3 100%);
        opacity: 0.82;
        z-index: 0;
        pointer-events: none;
    }
    .hero-content {
        position: relative;
        z-index: 2;
    }
    .hero-content h1 {
        font-size: 2.2rem;
        margin-bottom: 0.5rem;
        font-weight: 700;
        letter-spacing: 1px;
        text-shadow: 0 3px 10px rgba(44,62,80,0.16);
    }
    .hero-content p {
        font-size: 1.1rem;
        margin-bottom: 1.2rem;
    }
    section {
        padding: 35px 15px;
        max-width: 850px;
        margin: 0 auto;
    }
    h2 {
        color: var(--secondary);
        font-size: 1.7rem;
        margin-bottom: 12px;
        font-weight: 700;
        border-left: 4px solid var(--accent);
        padding-left: 8px;
    }
    .admission-info {
        background: #f4f9ff;
        border-left: 5px solid var(--secondary);
        padding: 18px 20px;
        border-radius: 5px;
        margin-bottom: 16px;
        font-size: 1.08rem;
    }
    .admission-steps {
        background: #fff;
        border-radius: 8px;
        padding: 24px 20px 10px 20px;
        box-shadow: 0 2px 14px 0 rgba(44,62,80,0.08);
        margin-bottom: 30px;
    }
    .admission-steps ol {
        margin-left: 20px;
        margin-bottom: 12px;
    }
    .admission-steps li {
        margin-bottom: 12px;
        font-size: 1.07rem;
    }
    .form-section-title {
        color: var(--primary);
        margin-bottom: 15px;
        margin-top: 30px;
        font-size: 1.1rem;
        font-weight: 700;
        letter-spacing: 1px;
    }
    form {
        background: #fff;
        border-radius: 10px;
        box-shadow: 0 2px 14px 0 rgba(44,62,80,0.08);
        padding: 30px 18px 24px 18px;
        margin-bottom: 30px;
    }
    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 500;
        color: var(--primary);
    }
    .required { color: red; }
    input[type="text"], input[type="date"], input[type="email"], input[type="tel"], input[type="password"], select, textarea {
        width: 100%;
        padding: 9px 10px;
        margin-bottom: 18px;
        border: 1px solid #dbe3ea;
        border-radius: 4px;
        font-size: 1rem;
        background: #fff;
        transition: border 0.2s;
    }
    textarea { min-height: 70px; }
    input[type="file"] {
        margin-bottom: 12px;
    }
    input:focus, select:focus, textarea:focus {
        border-color: var(--secondary);
        outline: none;
    }
    .form-row {
        display: flex;
        gap: 18px;
        flex-wrap: wrap;
    }
    .form-group {
        flex: 1 1 220px;
        min-width: 180px;
    }
    .form-gap {
        height: 38px;
    }
    .img-preview-wrap {
        text-align: center;
        margin-bottom: 10px;
    }
    .img-preview-wrap img {
        border-radius: 5px;
        border: 1px solid #dbe3ea;
        max-width: 114px;
        max-height: 140px;
        object-fit: cover;
        display: block;
        margin: 0 auto 6px auto;
    }
    .small-note {
        font-size:0.98em;
        color: #555;
        margin-bottom: 12px;
        font-style: italic;
    }
    .success-message, .error-message {
        padding: 12px 18px;
        border-radius: 5px;
        margin-bottom: 16px;
        display: none;
    }
    .success-message {
        color: #155724;
        background: #d4edda;
        border-left: 5px solid #28a745;
    }
    .error-message {
        color: #721c24;
        background: #f8d7da;
        border-left: 5px solid #e3342f;
    }
    .btn {
        background: var(--accent);
        color: #fff;
        padding: 0.7rem 2rem;
        border: none;
        border-radius: 25px;
        font-size: 1rem;
        font-weight: bold;
        cursor: pointer;
        box-shadow: 0 3px 10px rgba(0,0,0,0.10);
        transition: background 0.3s, transform 0.2s;
        text-decoration: none;
        display: inline-block;
    }
    .btn:hover, .btn:focus {
        background: var(--secondary);
        transform: scale(1.05);
    }
    footer {
        background: var(--footer);
        color: #fff;
        text-align: center;
        padding: 18px 0;
        margin-top: 30px;
        font-size: 1rem;
    }
    @media (max-width: 900px) {
        section { padding: 30px 5vw; }
    }
    @media (max-width: 700px) {
        .menu {
            display: none;
            position: absolute;
            right: 10px;
            top: 55px;
            flex-direction: column;
            background: var(--primary);
            width: 180px;
            box-shadow: 0 4px 16px rgba(44,62,80,0.09);
            z-index: 999;
            border-radius: 7px;
        }
        .menu.active { display: flex; }
        .menu-toggle {
            display: block;
            position: absolute;
            right: 20px;
            top: 2px;
        }
        .logo {
            font-size: 1.2rem;
            margin: 0.4rem 0;
        }
        .form-row { flex-direction: column; gap: 0; }
    }
    </style>
</head>
<body>
    <header>
        <div class="logo">
            <img src="Raisa-Computer-Training-Center-Facebook-Page-Logo.png" alt="Logo" class="logo-img">
            Raisa Computer Training Center
        </div>
        <nav>
            <ul class="menu">
                <li><a href="index.php">Home</a></li>
                <li><a href="admission.php" class="active">Admission</a></li>
                <li><a href="notice.php">Notice</a></li>
                <li><a href="about.php">About</a></li>
                <li><a href="online-class.php">Online Class</a></li>
                <li><a href="courses.php">Courses</a></li>
                <li><a href="reviews.php">Student Reviews</a></li>
                <li><a href="gallery.php">Gallery</a></li>
                <li><a href="contact.php">Contact</a></li>
            </ul>
            <div class="menu-toggle" id="menu-toggle">&#9776;</div>
        </nav>
    </header>
    <section class="hero" id="home" style="background: url('00f3981cab8d7549033b0d314539dd2e-2048x0-c-default.jpg') center center/cover no-repeat;">
        <div class="hero-content">
            <h1>Admission</h1>
            <p>Start your journey with Raisa Computer Training Center. Join our new batch and step ahead in IT!</p>
        </div>
    </section>
    <section>
        <div class="admission-info">
            <strong>Now open for new batch admission!</strong><br>
            For any queries, call: <a href="tel:017xxxxxxxx">017xxxxxxxx</a> or email: <a href="mailto:info@raisaict.com">info@raisaict.com</a>
        </div>
        <div class="admission-steps">
            <h2>How to Apply</h2>
            <ol>
                <li>Fill up the online admission form below or visit our training center.</li>
                <li>Submit required documents (NID/Birth Certificate copy, 1 passport-size photo).</li>
                <li>Pay the admission fee (details will be sent after form submission).</li>
                <li>Collect your student ID and class schedule.</li>
            </ol>
        </div>
        <div class="success-message" id="success-message"><?php if(!empty($success)) echo $success; ?></div>
        <div class="error-message" id="error-message" style="<?php if(!empty($error)) echo 'display:block;';?>"><?php if(!empty($error)) echo $error; ?></div>
        <form id="admissionForm" method="post" enctype="multipart/form-data" autocomplete="off">
            <!-- Personal Information -->
            <div class="form-section-title">Personal Information</div>
            <div class="form-row">
                <div class="form-group">
                    <label for="name">Full Name <span class="required">*</span></label>
                    <input type="text" name="name" id="name" required>
                </div>
                <div class="form-group">
                    <label for="father">Father's Name <span class="required">*</span></label>
                    <input type="text" name="father" id="father" required>
                </div>
                <div class="form-group">
                    <label for="mother">Mother's Name <span class="required">*</span></label>
                    <input type="text" name="mother" id="mother" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="dob">Date of Birth <span class="required">*</span></label>
                    <input type="date" name="dob" id="dob" required>
                </div>
                <div class="form-group" style="flex:2;">
                    <label for="address">Address <span class="required">*</span></label>
                    <input type="text" name="address" id="address" required>
                </div>
            </div>
            <div class="form-gap"></div>
            <!-- Course Section -->
            <div class="form-section-title">Course Information</div>
            <div class="form-row">
                <div class="form-group">
                    <label for="course_name">Course Name <span class="required">*</span></label>
                    <select name="course_name" id="course_name" required>
                        <option value="" disabled selected>Select a course</option>
                        <option>Office Application</option>
                        <option>Graphics Design</option>
                        <option>Web Design & Development</option>
                        <option>Video Editing</option>
                        <option>Data Entry</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="course_duration">Course Duration <span class="required">*</span></label>
                    <select name="course_duration" id="course_duration" required>
                        <option value="" disabled selected>Select duration</option>
                        <option>1 Month</option>
                        <option>2 Months</option>
                        <option>3 Months</option>
                        <option>6 Months</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="class_time">Class Time <span class="required">*</span></label>
                    <select name="class_time" id="class_time" required>
                        <option value="" disabled selected>Select class time</option>
                        <option>08:00 AM – 09:00 AM</option>
                        <option>09:00 AM – 10:00 AM</option>
                        <option>10:00 AM – 11:00 AM</option>
                        <option>11:00 AM – 12:00 AM</option>
                        <option>12:00 AM – 01:00 PM</option>
                        <option>04:00 PM – 05:00 PM</option>
                        <option>05:00 PM – 06:00 PM</option>
                        <option>06:00 PM – 07:00 PM</option>
                        <option>07:00 PM – 08:00 PM</option>
                        <option>08:00 PM – 09:00 PM</option>
                        <option>09:00 PM – 10:00 PM</option>

                    </select>
                </div>
                <div class="form-group">
                    <label for="course_fee">Course Fee <span class="required">*</span></label>
                    <select name="course_fee" id="course_fee" required>
                        <option value="" disabled selected>Select fee</option>
                        <option value="1000">1000 BDT</option>
                        <option value="1500">1500 BDT</option>
                        <option value="2000">2000 BDT</option>
                        <option value="2500">2500 BDT</option>
                        <option value="3000">3000 BDT</option>
                        <option value="4000">4000 BDT</option>
                        <option value="5000">5000 BDT</option>
                        <option value="6000">6000 BDT</option>
                        <option value="8000">8000 BDT</option>
                        <option value="10000">10000 BDT</option>
                    </select>
                </div>
            </div>
            <div class="form-gap"></div>
            <!-- Contact Section -->
            <div class="form-section-title">Contact Information</div>
            <div class="form-row">
                <div class="form-group">
                    <label for="email">Email Address <span class="required">*</span></label>
                    <input type="email" name="email" id="email" required>
                </div>
                <div class="form-group">
                    <label for="mobile">Mobile Number <span class="required">*</span></label>
                    <input type="tel" name="mobile" id="mobile" required placeholder="01XXXXXXXXX" pattern="01[0-9]{9}">
                </div>
                <div class="form-group">
                    <label for="whatsapp">Gurdian Phone Number <span class="required">*</span></label>
                    <input type="tel" name="whatsapp" id="whatsapp" required placeholder="01XXXXXXXXX" pattern="01[0-9]{9}">
                </div>
            </div>
            <div class="form-gap"></div>
            <!-- Photo Upload -->
            <div class="form-section-title">Upload Photo</div>
            <div class="img-preview-wrap">
                <img id="photoPreview" src="https://via.placeholder.com/114x140.png?text=Photo" alt="Preview">
                <div class="small-note">Photo size: 1.6x2 inch (114x140px), JPG/PNG, under 100KB</div>
            </div>
            <input type="file" name="photo" id="photo" accept="image/png,image/jpeg" required>
            <div class="form-gap"></div>
            <button type="submit" class="btn">Submit Application</button>
        </form>
        <div class="admission-info" style="background:#fff5ea; border-left-color:var(--accent); color:#b26509;">
            <strong>Office Address:</strong> Raisa Computer Training Center, City, District<br>
            <strong>Office Hours:</strong> 9:00 AM – 7:00 PM (Saturday–Thursday)
        </div>
    </section>
    <footer>
        <p>&copy; 2025 Raisa Computer Training Center. All rights reserved.</p>
    </footer>
    <script>
        // Mobile menu toggle
        document.addEventListener('DOMContentLoaded', function() {
            const menuToggle = document.getElementById('menu-toggle');
            const menu = document.querySelector('.menu');
            menuToggle.addEventListener('click', function() {
                menu.classList.toggle('active');
            });
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    if (document.querySelector(this.getAttribute('href'))) {
                        e.preventDefault();
                        document.querySelector(this.getAttribute('href')).scrollIntoView({
                            behavior: 'smooth'
                        });
                        if (window.innerWidth < 700) menu.classList.remove('active');
                    }
                });
            });
        });

        // Photo Preview & Validation
        const photoInput = document.getElementById('photo');
        const photoPreview = document.getElementById('photoPreview');
        const errorDiv = document.getElementById('error-message');
        photoInput.addEventListener('change', function(e){
            const file = this.files[0];
            errorDiv.style.display = 'none';
            if (file) {
                if (!['image/jpeg','image/png'].includes(file.type)) {
                    errorDiv.textContent = 'Only JPG or PNG allowed!';
                    errorDiv.style.display = "block";
                    photoInput.value = '';
                    photoPreview.src = "https://via.placeholder.com/114x140.png?text=Photo";
                    return;
                }
                if (file.size > 102400) {
                    errorDiv.textContent = 'Photo must be under 100KB!';
                    errorDiv.style.display = "block";
                    photoInput.value = '';
                    photoPreview.src = "https://via.placeholder.com/114x140.png?text=Photo";
                    return;
                }
                const reader = new FileReader();
                reader.onload = function(ev) {
                    const img = new Image();
                    img.onload = function() {
                        if (img.width !== 114 || img.height !== 140) {
                            const canvas = document.createElement('canvas');
                            canvas.width = 114; canvas.height = 140;
                            const ctx = canvas.getContext('2d');
                            ctx.fillStyle = "#fff";
                            ctx.fillRect(0,0,114,140);
                            let scale = Math.min(114/img.width, 140/img.height);
                            let w = img.width * scale, h = img.height * scale;
                            let x = (114-w)/2, y = (140-h)/2;
                            ctx.drawImage(img, x, y, w, h);
                            photoPreview.src = canvas.toDataURL(file.type);
                        } else {
                            photoPreview.src = ev.target.result;
                        }
                    }
                    img.src = ev.target.result;
                }
                reader.readAsDataURL(file);
            } else {
                photoPreview.src = "https://via.placeholder.com/114x140.png?text=Photo";
            }
        });

        // Client-side form validation (extra layer)
        document.getElementById('admissionForm').addEventListener('submit', function(e){
            errorDiv.style.display = 'none';
            if(photoPreview.src.indexOf('placeholder.com') !== -1) {
                errorDiv.textContent = 'Please select and upload your photo!';
                errorDiv.style.display = "block";
                e.preventDefault();
            }
        });
    </script>
</body>
</html>