<?php
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
        }
        .header {
            text-align: center;
            padding: 20px;
            background-color: #007BFF;
            color: white;
        }
        .header h1 {
            margin: 0;
        }
        .buttons-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
            margin-top: 30px;
        }
        .button {
            width: 200px;
            height: 100px;
            background-color: #ff1D8D;
            color: white;
            display: flex;
            justify-content: center;
            align-items: center;
            text-transform: uppercase;
            font-size: 1.2rem;
            font-weight: bold;
            border-radius: 10px;
            text-decoration: none;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        .button:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Welcome To Admin Panel, <?= htmlspecialchars($_SESSION['username']); ?>!</h1>
    </div>
    <div class="buttons-container">
        <a href="result_entry.html" class="button">Result Upload</a>
        <a href="add_teacher.php" class="button">Add Teacher's</a>
        <a href="admin_notice_upload.php" class="button">Notice Update</a>
        <a href="student_id.php" class="button">Student ID Card</a>
        <a href="admit_card_search.html" class="button">Admit Card</a>
        <a href="expense_emtry.php" class="button">Davit/Expance</a>
        <a href="income_form.php" class="button">Cradit/Income</a>
        <a href="reporting_page.php" class="button">Cradit/<br>Davit Report</a>
        <a href="login.php" class="button">Logout</a>
    </div>
</body>
</html>